package cn.com.duiba.live.normal.service.api.remoteservice.advice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.advice.LiveAgentAdviceStatisticsDto;
import cn.com.duiba.live.normal.service.api.param.advice.LiveAgentAdviceStatisticsSearchParam;

import java.util.List;

/**
 * 直播聊天室-统计
 * @author liuchao1
 * @version 1.0
 * @date 2020-07-01 11:09
 */
@AdvancedFeignClient
public interface RemoteLiveAgentAdviceStatisticsApiService {

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播代理人咨询统计集合
     */
    List<LiveAgentAdviceStatisticsDto> selectPage(LiveAgentAdviceStatisticsSearchParam param);

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 直播代理人咨询统计集合
     */
    List<LiveAgentAdviceStatisticsDto> selectList(LiveAgentAdviceStatisticsSearchParam param);

    /**
     * 根据参数统计符合条件的总数
     * @param param 查询条件
     * @return 符合条件的总数
     */
    int selectCount(LiveAgentAdviceStatisticsSearchParam param);

    /**
     * 根据聊天室sessionKey批量查询
     * @param sessionKeyList 聊天室sessionKey
     * @return 直播代理人咨询记录集合
     */
    List<LiveAgentAdviceStatisticsDto> selectBySessionKeyList(List<String> sessionKeyList);

    /**
     * 批量新增
     * @param list 代理人咨询统计信息集合
     * @return 执行结果
     */
    int batchInsert(List<LiveAgentAdviceStatisticsDto> list);

    /**
     * 批量更新代理人咨询统计信息
     * @param list 代理人咨询统计信息集合
     * @return 执行结果
     */
    int batchUpdate(List<LiveAgentAdviceStatisticsDto> list);

}
