package cn.com.duiba.live.normal.service.api.remoteservice.black;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.black.LiveBlackListDto;
import cn.com.duiba.live.normal.service.api.param.black.LiveBlackListDtoSearchParam;

import java.util.List;
import java.util.Set;

/**
 * 直播黑名单
 * @author lizhi
 * @date 2020/7/30 10:04 AM
 */
@AdvancedFeignClient
public interface RemoteLiveBlackListApiService {

    /**
     * 查询在黑名单里的用户
     * @param liveUserIds 需要校验的直播用户ID集合
     * @return 在黑名单里的用户ID集合
     */
    List<Long> findByLiveUserIds(List<Long> liveUserIds);

    /**
     * 查询在黑名单里的用户
     * @param liveUserIds 需要校验的直播用户ID集合
     * @return 在黑名单里的用户ID集合
     */
    Set<Long> findByLiveUserIdSet(List<Long> liveUserIds);

    /**
     * 批量新增
     * @param list 直播黑名单
     * @return 执行结果
     */
    int batchInsert(List<LiveBlackListDto> list);

    /**
     * 批量物理删除
     * @param liveUserIds 直播用户ID集合
     * @return 执行结果
     */
    int batchDelete(List<Long> liveUserIds);

    /**
     * 根据主键查询
     * @param id 主键id
     * @return 直播黑名单对象
     */
    LiveBlackListDto findById(Long id);

    /**
     * 根据直播用户id 查询
     * @param liveUserId 直播用户id
     * @return 直播黑名单信息
     */
    LiveBlackListDto findByLiveUserId(Long liveUserId);

    /**
     * 根据条件查询列表
     * @param param 查询条件
     * @return 直播黑名单列表
     */
    List<LiveBlackListDto> findByCondition(LiveBlackListDtoSearchParam param);

    /**
     * 根据条件统计总数
     * @param param 查询条件
     * @return 总数
     */
    int countByCondition(LiveBlackListDtoSearchParam param);
}
