package cn.com.duiba.live.normal.service.api.remoteservice.rewardSignRecord;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.rewardSignRecord.LiveRewardSignRecordDto;
import cn.com.duiba.live.normal.service.api.dto.rewardSignRecord.LiveRewardSignStatisticsDto;
import cn.com.duiba.live.normal.service.api.param.rewardSignRecord.LiveRewardSignRecordSearchParam;

import java.util.List;

/**
 * 直播奖品签收记录
 *
 * @author xiaotian
 * @date 2021/01/26 8:51 PM
 */
@AdvancedFeignClient
public interface RemoteLiveRewardSignRecordApiService {

    /**
     * 根据条件查询，不分页
     * 手机端查询查询中奖页分页使用
     * @param param 查询条件
     * @return 直播抽奖码集合
     */
    List<LiveRewardSignRecordDto> selectList(LiveRewardSignRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * 手机端查询查询中奖页分页使用
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(LiveRewardSignRecordSearchParam param);

    /**
     * 根据liveUserId更新记录
     *
     * @return 抽奖码集合
     */
    boolean check(LiveRewardSignRecordDto liveRewardSignRecordDto);


    /**
     * 根据liveUserId更新记录
     *
     * @return 抽奖码集合
     */
    boolean sign(LiveRewardSignRecordDto liveRewardSignRecordDto);


    /**
     * 根据liveId和liveUserId 获取中奖记录
     * @param liveId
     * @param liveUserId
     * @return
     */
    LiveRewardSignRecordDto selectByLiveIdAndUserId(Long liveId,Long liveUserId);


    /**
     * 获取统计数量
     * @param liveId
     * @param agantId
     * @return
     */
    LiveRewardSignStatisticsDto  getStatistics(Long liveId,Long agantId);

    /**
     * 批量根据直播Id和中奖用户id更新
     * @param liveRewardSignRecordDtos
     * @return
     */
    int batchUpdateByLiveIdAndLiveUserId(List<LiveRewardSignRecordDto> liveRewardSignRecordDtos);

    /**
     * 根据代理人和直播Id获取统计数据列表
     * @param agentId 代理人Id
     * @param liveIds 直播Id列表
     * @return 统计数据列表
     */
    List<LiveRewardSignStatisticsDto> selectByAgentIdAndLiveIds(Long agentId, List<Long> liveIds);

    /**
     * 根据直播间id + 代理人id + 直播用户id 批量查询签收信息
     * @param livId 直播间id
     * @param agentId 代理人id
     * @param liveUserIds 直播用户id
     * @return 签收信息
     */
    List<LiveRewardSignRecordDto> selectByLiveIdAgentIdLiveVisitorIds(Long livId,Long agentId,List<Long> liveUserIds);
}
