package cn.com.duiba.live.normal.service.api.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

/**
 * Created by dugq on 2020-06-03.
 */
@Slf4j
public class LotteryCodeUtil {
    //25进值对照表
    private static final Character[] PLACEHOLDERS = new Character[]{'M', 'F', 'T', 'A', 'S', 'X', 'D', 'P', 'C', 'I', 'Y', 'V', 'N', 'L', 'J', 'Q', 'E', 'U', 'Z', 'K', 'R', 'B', 'H', 'O', 'W', 'G'};

    //35 进制对照表
    private static final Character[] PLACEHOLDERS2 = new Character[]{'K', 'Q','L','M', 'F', 'T','A', 'S', 'X', 'D', 'P', 'C', 'I', 'Y', 'V', 'N', '0', 'J','E', 'U','6', 'Z','7', 'R', '3', 'B','4', 'H','8', 'O', '1','W','2','9', 'G','5'};


    private static final List<String> RANDOM_LIST;

    /**
     * 支持的最大可还原ID，超过此ID时，将会取模运算
     */
    private static final Long MAX_LIVE_ID = 25*25L;

    /**
     * 抽奖码位数
     */
    private static final int ZMByte = 2;

    private static final int numByte = 4;
    /**
     * 字母位支持的最大ID
     */
    private static final int MAX_ZM_CODE_ID = (int)Math.pow(35,ZMByte);

    /**
     * 数字位支持的最大ID
     */
    private static final int MAX_NUM_CODE_ID = (int)Math.pow(10,numByte);

    /**
     * 支持的总最大ID
     */
    private static final int MAX_LOTTERY_CODE_ID = MAX_ZM_CODE_ID * MAX_NUM_CODE_ID;



    static {
       String str = "99,30,74,75,35,17,67,43,01,62,03,66,84,79,26,39,97,52,25,87,55,60,05,44,90,70,63,06,13,11,28,83,72,82,32,37,64,14,10,57,40,00,45,81,96,42,09,19,04,23,18,12,16,47,02,91,80,36,76,29,48,24,56,33,92,78,50,41,07,31,34,21,89,86,08,73,22,69,51,98,27,88,68,94,71,38,85,49,15,93,54,77,61,53,95,46,20,58,59,65";
       String[]  split = StringUtils.split(str,",");
        RANDOM_LIST = Collections.unmodifiableList(Arrays.asList(split));
        str = null;
        split = null;
    }

    /**
     * 私有化
     */
    private LotteryCodeUtil(){ }

    public static String encodeId2String(Long liveId,Long lotteryCodeId){
        if (Objects.isNull(liveId)||Objects.isNull(lotteryCodeId)){
            return null;
        }
        int cId=(int)(lotteryCodeId+liveId*3+777);
        if (lotteryCodeId>MAX_LOTTERY_CODE_ID){
            cId = cId%MAX_LOTTERY_CODE_ID;
        }
        //高位字母位
        final int highNum = cId / MAX_NUM_CODE_ID;
        //地位数字位
        final int lowNum = cId - highNum;
        final int firstZMByte = highNum / 35;
        final int secondZMByte = highNum%35;
        final Character firstChar = PLACEHOLDERS2[firstZMByte];
        final Character secondChar = PLACEHOLDERS2[secondZMByte];
//        final Pair<Character, Character> livePair = getTwoCharByLiveId(liveId);
//        final Pair<String, String> codePair = getDoubleFourByteNumById(lotteryCodeId);
//        return livePair.getLeft()+codePair.getLeft() +livePair.getRight() + codePair.getRight();
        final Pair<String, String> lowDoubleChar = getDoubleTwoCharByte(lowNum);
        return ""+firstChar+secondChar+lowDoubleChar.getLeft()+lowDoubleChar.getRight();
    }

    @NotNull
    private static Character getCharacter(List<Integer> byteList, int i) {
        return PLACEHOLDERS2[byteList.get(i)];
    }

    private static List<Integer> get35ByteList(int num){
        if (num>MAX_LOTTERY_CODE_ID){
            num = num % MAX_LOTTERY_CODE_ID;
        }
        if (num == 0 ){
            return Arrays.asList(0,0,0,0);
        }
        List<Integer> chars = new ArrayList<>();
        while (true){
            if (num>35){
                int larger = num /35;
                chars.add(num - larger*35);
                num = larger;
            }else{
                chars.add(num);
                break;
            }
        }
        final int size = chars.size();
        if (size <4){
            for (int i = 0; i < 4- size; i++){
                chars.add(0);
            }
        }
        return chars;
    }

    private static Pair<Character,Character> getTwoCharByLiveId(long liveId){
        if (liveId>MAX_LIVE_ID){
            liveId = liveId % MAX_LIVE_ID;
        }
        int first = (int)liveId % 25;
        int last = (int)liveId / 25;
        return ImmutablePair.of(PLACEHOLDERS[first], PLACEHOLDERS[last]);
    }

    /**
     * 保留，万一又变了呢
     * @param lotteryCodeId
     * @return
     */
    private static Pair<String,String> getDoubleFourByteNumById(long lotteryCodeId){
        if (lotteryCodeId>MAX_LOTTERY_CODE_ID){
            lotteryCodeId = lotteryCodeId % MAX_LOTTERY_CODE_ID;
        }
        final long lowFourByte = lotteryCodeId % 100000;
        final long highFourByte = lotteryCodeId / 10000;
        final Pair<String, String> highPair = getDoubleTwoCharByte(highFourByte);
        final Pair<String, String> lowPair = getDoubleTwoCharByte(lowFourByte);
        return ImmutablePair.of(lowPair.getLeft()+highPair.getRight(),lowPair.getRight()+highPair.getLeft());
    }

    private static Pair<String,String> getDoubleTwoCharByte(long sourceNum){
        if (sourceNum>=10000){
            sourceNum = sourceNum % 10000;
        }
        final long lowTwoByte = sourceNum % 100;
        final long highTwoByte = sourceNum / 100;
        return ImmutablePair.of(RANDOM_LIST.get((int) highTwoByte), RANDOM_LIST.get((int) lowTwoByte));
    }

    public static void main(String[] args) {
        System.out.println(encodeId2String(1L,39968L));
        System.out.println(encodeId2String(1L,35000L));
        final long start = System.currentTimeMillis();
        HashMap<String,String> set = new HashMap<>();
        for (long i = 0 ; i < MAX_LOTTERY_CODE_ID; i++){
            final String old = set.put(encodeId2String(0L, i), i+"");
            if (Objects.nonNull(old)){
                System.out.println(old + "==== "+i);
            }
        }
        final long cost = System.currentTimeMillis() - start;
        System.out.println("cost ======= "+cost+"\nsize="+set.size());
    }
}
