package cn.com.duiba.live.normal.service.api.dto.oto.cust;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.visit.OtoCustVisitStatusEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.cust.visit.OtoCustCommitStatusEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.cust.visit.OtoCustFamilyTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 客户参观记录表
 * @author kjj mybatis generator 
 * @date 2022-01-10
 */
@Data
public class CustVisitRecordDto implements Serializable {
     
    private static final long serialVersionUID = 1641794523446518L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 参观状态 1已预约 2已上传参观反馈
     * @see OtoCustVisitStatusEnum
     */
    private Integer visitStatus;

    /**
     * 预约参观日期
     */
    private Date orderVisitTime;

    /**
     * 成交决策人 1自己 2配偶 3父母 4子女
     * @see OtoCustFamilyTypeEnum
     */
    private Integer dealMaker;

    /**
     * 理念是否认同 0不认同 1认同
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer ideaAgree;

    /**
     * 投保人 1自己 2配偶 3父母 4子女
     * @see OtoCustFamilyTypeEnum
     */
    private String insApplicant;

    /**
     * 被投保人 1自己 2配偶 3父母 4子女
     * @see OtoCustFamilyTypeEnum
     */
    private String insByApplicant;

    /**
     * 投保金额
     */
    private Integer insMoney;

    /**
     * 投保期数
     */
    private Integer insPeriod;

    /**
     * 提交计划书后客户状态 1近期有机会成交 2近期无法成交 3拒绝
     * @see OtoCustCommitStatusEnum
     */
    private Integer commitCustStatus;

    /**
     * 是否提交计划书 0否 1是
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer commitPlanFlag;

    /**
     * 参观备注
     */
    private String visitRemark;
}