package cn.com.duiba.live.normal.service.api.enums.oto.cust.ext;

import com.google.common.collect.Sets;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Collections;
import java.util.Set;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-05 17:23
 */
@Getter
@AllArgsConstructor
public enum OtoCustValueEnum {

    X("X", 101,  "拨打未接通次数 >= 5"),
    N("N", 102,"拨打次数5次内未接通"),
    ZERO("0", 200, "销售手动输入"),
    ONE("1", 201, "销售手动输入"),
    TWO("2", 202, "销售手动输入"),
    THREE("3", 203, "销售手动输入"),
    THREE_A("3-A", 301, ""),
    THREE_B("3-B", 302, ""),
    THREE_C("3-C", 303, "");

    /**
     * 展示价值
     */
    private final String showValue;

    /**
     * 价值
     */
    private final Integer realValue;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 低级价值
     */
    private static final Set<Integer> LOWER_VALUE_LIST = Collections.unmodifiableSet(Sets.newHashSet(X.getRealValue(), N.getRealValue(), ZERO.getRealValue()));

    /**
     * 手动输入数字价值
     */
    private static final Set<Integer> NUMBER_VALUE_LIST = Collections.unmodifiableSet(Sets.newHashSet(ZERO.getRealValue(), ONE.getRealValue(), TWO.getRealValue(), THREE.getRealValue()));

    /**
     * 是否可以替换为新的value
     * @param oldValue 老的value
     * @param newValue 新的value
     * @return 是否可以替换
     */
    public static boolean canReplace(Integer oldValue, Integer newValue){
        if (oldValue == null || newValue == null) {
            return false;
        }

        // 0-3只允许增大
        if (NUMBER_VALUE_LIST.contains(oldValue) && NUMBER_VALUE_LIST.contains(newValue)) {
            return newValue > oldValue;
        }

        // X/N/0可以互相切换
        if (LOWER_VALUE_LIST.contains(oldValue)){
            return LOWER_VALUE_LIST.contains(newValue);
        }
        return false;
    }
}
