/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.normal.service.api.enums.oto;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum OtoCustFollowStatusEnum {
    CONTACT(1, "\u9700\u8981\u8054\u7cfb"),
    MEET(2, "\u9700\u8981\u7ea6\u89c1"),
    PLAN(3, "\u8981\u53d1\u8ba1\u5212\u4e66"),
    TO_DEAL(4, "\u5f85\u4fc3\u6210");

    private final Integer status;
    private final String desc;
    private static final Map<Integer, String> FOLLOW_STATUS_MAP;

    public static String getDescByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return FOLLOW_STATUS_MAP.get(status);
    }

    private OtoCustFollowStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        FOLLOW_STATUS_MAP = Collections.unmodifiableMap(Arrays.stream(OtoCustFollowStatusEnum.values()).collect(Collectors.toMap(OtoCustFollowStatusEnum::getStatus, OtoCustFollowStatusEnum::getDesc, (v1, v2) -> v1)));
    }
}

