package cn.com.duiba.live.normal.service.api.remoteservice.clue;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.clue.LiveClueShareDto;

import java.util.List;
import java.util.Map;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020-07-24 15:00
 */
@AdvancedFeignClient
public interface RemoteLiveClueShareApiService {

    /**
     * 批量保存或更新
     * @param list 分享线索集合
     * @return 执行结果
     */
    int batchSaveOrUpdate(List<LiveClueShareDto> list);


    /**
     * 查询用户分享次数
     */
    Map<Long,Integer> selectShareNumByLiveAndUser(Long liveId, List<Long> liveUserIds);

    /**
     * !!!!!!!数据修复专用 其它地方慎用!!!!!
     * 更新分享线索数据
     * @param liveId 直播间id
     * @param visitorIds 访客id列表
     * @param agentId 代理人id
     * @return 影响行数
     */
    int updateAgentId4DataFix(Long liveId, List<Long> visitorIds, Long agentId);
}
