/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.normal.service.api.enums.oto.cust;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public enum OtoCustValueEnum {
    X("X", "101", "\u62e8\u6253\u672a\u63a5\u901a\u6b21\u6570 >= 5"),
    N("N", "102", "\u62e8\u6253\u6b21\u65705\u6b21\u5185\u672a\u63a5\u901a"),
    ZERO("0", "200", "\u9500\u552e\u624b\u52a8\u8f93\u5165"),
    ONE("1", "201", "\u9500\u552e\u624b\u52a8\u8f93\u5165"),
    TWO("2", "202", "\u9500\u552e\u624b\u52a8\u8f93\u5165"),
    THREE("3", "203", "\u9500\u552e\u624b\u52a8\u8f93\u5165"),
    THREE_A("3-A", "301", ""),
    THREE_B("3-B", "302", ""),
    THREE_C("3-C", "303", "");

    private final String showValue;
    private final String realValue;
    private final String desc;
    private static final Set<String> LOWER_VALUE_LIST;
    private static final Set<String> NUMBER_VALUE_LIST;

    public static boolean canReplace(String oldValue, String newValue) {
        if (StringUtils.isBlank((String)oldValue) || StringUtils.isBlank((String)newValue)) {
            return false;
        }
        if (NUMBER_VALUE_LIST.contains(oldValue) && NUMBER_VALUE_LIST.contains(newValue)) {
            return Integer.parseInt(newValue) > Integer.parseInt(oldValue);
        }
        if (LOWER_VALUE_LIST.contains(oldValue)) {
            return LOWER_VALUE_LIST.contains(newValue);
        }
        return false;
    }

    public String getShowValue() {
        return this.showValue;
    }

    public String getRealValue() {
        return this.realValue;
    }

    public String getDesc() {
        return this.desc;
    }

    private OtoCustValueEnum(String showValue, String realValue, String desc) {
        this.showValue = showValue;
        this.realValue = realValue;
        this.desc = desc;
    }

    static {
        LOWER_VALUE_LIST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{X.getRealValue(), N.getRealValue(), ZERO.getRealValue()}));
        NUMBER_VALUE_LIST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{ZERO.getRealValue(), ONE.getRealValue(), TWO.getRealValue(), THREE.getRealValue()}));
    }
}

