package cn.com.duiba.live.normal.service.api.enums.oto.cust.ext;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-12 19:59
 */
@Getter
@AllArgsConstructor
public enum OtoCustHouseEnum {

    UN_KNOW(-1, "不详"),
    NO_HOUSE(0, "0"),
    ONE_HOUSE(1, "1"),
    TWO_HOUSE(2, "2"),
    THREE_HOUSE(3, "3及以上");

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustHouseEnum::getType, OtoCustHouseEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据类型获取描述
     */
    public static String getDescByType(Integer type){
        if (type == null) {
            return null;
        }
        return ALL_MAP.get(type);
    }

    public static boolean hasHousePower(Integer hasHouse) {
        return ONE_HOUSE.getType().equals(hasHouse) || TWO_HOUSE.getType().equals(hasHouse) || THREE_HOUSE.getType().equals(hasHouse);
    }
}
