package cn.com.duiba.live.normal.service.api.remoteservice.oto.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.company.OtoCompanyExtDto;

import java.util.List;
import java.util.Map;

/**
 * OTO-公司扩展配置
 *
 * @author ZhangJun
 * @date 2022/3/7 16:13
 */
@AdvancedFeignClient
public interface RemoteOtoCompanyExtService {

    /**
     * 新增公司扩展配置
     *
     * @param extDto 拓展配置
     * @return 是否新增成功
     */
    boolean saveCompanyExtConf(OtoCompanyExtDto extDto);

    /**
     * 批量新增或更新
     *
     * @param extDtos 拓展配置集合
     * @return 执行结果
     */
    boolean batchInsertOrUpdate(List<OtoCompanyExtDto> extDtos);

    /**
     * 批量查询公司所有扩展配置
     *
     * @param companyIds 直播公司id
     * @return 直播公司配置
     */
    List<OtoCompanyExtDto> getAllConfByCompanyIds(List<Long> companyIds);

    /**
     * 批量查询公司所有扩展配置
     *
     * @param companyId 直播公司id
     * @return 直播公司配置
     */
    List<OtoCompanyExtDto> getAllConfByCompanyId(Long companyId);

    /**
     * 根据公司id+配置key 查询
     *
     * @param companyId 直播公司id
     * @param confName  配置名称
     * @return 配置信息
     */
    OtoCompanyExtDto findByCompanyIdAndConfName(Long companyId, Integer confName);

    /**
     * 批量获取公司扩展配置
     *
     * @param companyIds 直播公司id列表
     * @param confName   配置名称
     * @return key:liveId val:confVal
     * @see cn.com.duiba.live.normal.service.api.enums.oto.company.OtoCompanyExtEnum
     */
    Map<Long, String> getConfValuesByCompanyIds(List<Long> companyIds, Integer confName);

    /**
     * 根据公司id+配置名称列表查询
     *
     * @param companyId    直播公司id
     * @param confNameList 配置名称列表
     * @return 配置列表
     */
    List<OtoCompanyExtDto> findByCompanyIdAndKeys(Long companyId, List<Integer> confNameList);

    /**
     * 根据公司id和配置名称批量查询
     *
     * @param companyIds 公司id集合
     * @param confNames  配置名称集合
     * @return 配置
     */
    List<OtoCompanyExtDto> getByCompanyIdsAndConfNames(List<Long> companyIds, List<Integer> confNames);

}
