package cn.com.duiba.live.normal.service.api.remoteservice.specify.award;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.specify.award.SpecifyAwardAgentListDto;
import java.util.List;

/**
 * @author guoxuebiao
 * @date 2021/11/5 5:38 下午
 */
@AdvancedFeignClient
public interface RemoteSpecifyAwardAgentListApiService {

    /**
     * 根据直播id查询
     * @param liveId 直播id
     * @return 指定中奖代理人工号
     */
    List<SpecifyAwardAgentListDto> selectByLiveId(Long liveId);

    /**
     * 批量物理删除
     * @param ids id集合
     * @return 执行结果
     */
    int batchDelete(List<Long> ids);

    /**
     * 批量新增
     * @param dtoList 指定中奖代理人工号列表
     * @return 执行结果
     */
    int batchInsert(List<SpecifyAwardAgentListDto> dtoList);
}
