package cn.com.duiba.live.normal.service.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.agent.LiveAgentInviteAuthImportDto;
import cn.com.duiba.live.normal.service.api.param.agent.LiveAgentInviteAuthImportSearchParam;

import java.util.List;

/**
 * 直播代理人邀请权限可参与名单
 *
 * @author xuzhigang
 * @date 2021/3/4 4:29 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentInviteAuthImportApiService {
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 直播代理人邀请权限参与名单集合
     */
    List<LiveAgentInviteAuthImportDto> selectListPage(LiveAgentInviteAuthImportSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveAgentInviteAuthImportSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播代理人邀请权限参与名单
     */
    LiveAgentInviteAuthImportDto selectById(Long id);

    /**
     * 根据直播id和工号查询参与名单
     *
     * @param liveId 直播id
     * @param jobNumber 工号
     * @return 参与名单
     */
    LiveAgentInviteAuthImportDto selectByLiveIdAndJobNumber(Long liveId, String jobNumber);

    /**
     * 根据直播id和工号查询参与名单
     *
     * @param liveId 直播id
     * @param jobNumbers 工号
     * @return 参与名单
     */
    List<LiveAgentInviteAuthImportDto> selectByLiveIdAndJobNumbers(Long liveId, List<String> jobNumbers);

    /**
     * 批量新增
     * @param dtoList 直播代理人邀请权限参与名单
     * @return 执行结果
     */
    int batchInsert(List<LiveAgentInviteAuthImportDto> dtoList);

    /**
     * 批量删除
     * @param ids id集合
     * @return 执行结果
     */
    int batchDelete(List<Long> ids);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
