package cn.com.duiba.live.normal.service.api.remoteservice.chinalife;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.chinalife.ChinaLifeVisitorRelatedDto;

/**
 * 国寿访客用户关联表
 * @author kjj mybatis generator 
 * @date 2021-03-24
 */
@AdvancedFeignClient
public interface RemoteChinaLifeVisitorRelatedService {

    /**
     * 根据直播id和手机号查询
     *
     * @param liveId 直播id
     * @param phoneNumber 手机号
     * @return 关联关系
     */
    ChinaLifeVisitorRelatedDto findByLiveIdAndPhoneNumber(Long liveId, String phoneNumber);

    /**
     * 更新
     * @param dto 国寿访客用户关联
     * @return 执行结果
     */
    int update(ChinaLifeVisitorRelatedDto dto);

    /**
     * 更新客集集直播用户id
     * @param id 主键
     * @param kjjLiveUserId 客集集直播用户id
     * @return 执行结果
     */
    int updateKjjLiveUserId(Long id, Long kjjLiveUserId);
}