package cn.com.duiba.live.normal.service.api.remoteservice.guide;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.guide.GuideVideoDto;
import cn.com.duiba.live.normal.service.api.param.guide.GuideVideoSearchParam;

import java.util.List;
import java.util.Map;

/**
 * 引导视频
 * @author lizhi
 * @date 2020/11/17 11:35 上午
 */
@AdvancedFeignClient
public interface RemoteGuideVideoApiService {

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 引导视频集合
     */
    List<GuideVideoDto> selectPage(GuideVideoSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(GuideVideoSearchParam param);

    /**
     * 批量查询类型对应记录数
     * @param videoTypeList 类型集合
     * @see cn.com.duiba.live.normal.service.api.enums.guide.GuideVideoTypeEnum
     * @return key：类型， value：记录数
     */
    Map<Integer, Long> selectTypeCount(List<Integer> videoTypeList);

    /**
     * 批量查询类型对应所有的ID
     * 注意，该方法只适用于视频量小于100时
     * @param videoTypeList 类型集合
     * @return key：类型， value：视频主键集合
     */
    Map<Integer, List<Long>> selectTypeAllIds(List<Integer> videoTypeList);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 引导视频
     */
    GuideVideoDto selectById(Long id);

    /**
     * 上移
     * @param id 主键
     * @return 结果
     */
    boolean up(Long id);

    /**
     * 下移
     * @param id 主键
     * @return 结果
     */
    boolean down(Long id);

    /**
     * 删除
     * @param id 主键
     * @return 结果
     */
    int delete(Long id);

    /**
     * 新增
     * @param dto 引导视频
     * @return 执行结果
     */
    int insert(GuideVideoDto dto);

    /**
     * 更新
     * @param dto 引导视频
     * @return 执行结果
     */
    int update(GuideVideoDto dto);

    /**
     * 更新视频时长（只有原来videoTime为0时能更新成功）
     * @param id 主键
     * @param videoTime 视频总时长，单位秒
     * @return 执行结果
     */
    int updateVideoTime(Long id, Integer videoTime);
}
