package cn.com.duiba.live.normal.service.api.remoteservice.oto.interview;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.interview.AppointmentDetailDTO;
import cn.com.duiba.live.normal.service.api.dto.oto.interview.BatchSaveInterviewResultDTO;

import java.util.Date;
import java.util.List;

/**
 * 描述：手机工作台1.0，客户面访
 *
 * @author zhouziwu
 * @date 2022-03-23
 */
@AdvancedFeignClient
public interface RemoteCustInterviewService {
    /**
     * 客户参观社区，查询预约面访详情
     * @param custId 客户id
     * @param sellerId 销售id
     * @param interviewType 面访类型，1:普通面访 2:社区面访
     * @param interviewStatus 面访状态：{@link cn.com.duiba.live.normal.service.api.enums.oto.OtoCustInterviewStatusEnum}
     * @return AppointmentDetailDTO
     */
    AppointmentDetailDTO findAppointmentDetail(Long custId, Long sellerId, Integer interviewType, List<Integer> interviewStatus);

    /**
     * 批量创建客户面访记录
     * 1、一批客户中都没有正在进行中的面访，则创建成功并返回面访码ID集合；
     * 2、有一个以上有进行中面访，则创建失败，并返回不能创建的客户ID。
     * @param sellerId 销售ID
     * @param interviewType 面访类型，1:普通面访 2:社区面访
     * @param interviewStatus 面访状态：{@link cn.com.duiba.live.normal.service.api.enums.oto.OtoCustInterviewStatusEnum}
     * @param custIds 客户ID集合
     * @return info
     */
    BatchSaveInterviewResultDTO batchSaveInterviewInfo(Long sellerId, Integer interviewType, List<Integer> interviewStatus, List<Long> custIds);

    /**
     * 参观社区-预约面访编辑
     * @param id 客户面访码ID
     * @param appointmentTime 预约客户参观的时间
     * @return boolean
     */
    Boolean appointmentUpdate(Long id, Date appointmentTime);

    /**
     * 取消面访
     * @param interviewId 面访ID
     * @return 操作结果
     */
    Boolean cancelInterview(Long interviewId) throws BizException;

}
