package cn.com.duiba.live.normal.service.api.remoteservice.spoke;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.spoke.LiveSpokeStoreDto;
import cn.com.duiba.live.normal.service.api.param.spoke.LiveSpokeStoreSearchParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Map;

/**
 * 直播评论库
 * @author kjj mybatis generator 
 * @date 2021-02-23
 */
@AdvancedFeignClient
public interface RemoteLiveSpokeStoreService {

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播评论库集合
     */
    List<LiveSpokeStoreDto> selectPage(LiveSpokeStoreSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveSpokeStoreSearchParam param);


    /**
     * 从es搜索
     * @param param 搜索条件
     * @return left：符合条件的总数 value：当前页结果
     */
    Pair<Long, List<LiveSpokeStoreDto>> searchFromEs(LiveSpokeStoreSearchParam param);

    /**
     * 根据评论类目id获取评论总数
     * @param categoryIds 评论类目id集合
     * @return key：评论类目id value：评论总数
     */
    Map<Long, Long> getCountByCategoryIds(List<Long> categoryIds);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播评论库
     */
    LiveSpokeStoreDto selectById(Long id);

    /**
     * 新增
     * @param dto 直播评论库
     * @return 执行结果
     */
    int insert(LiveSpokeStoreDto dto);

    /**
     * 更新
     * @param dto 直播评论库
     * @return 执行结果
     */
    int update(LiveSpokeStoreDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}