package cn.com.duiba.live.normal.service.api.remoteservice.oto.interview;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.interview.AppointmentDetailDTO;
import cn.com.duiba.live.normal.service.api.dto.oto.interview.BatchSaveInterviewResultDTO;
import cn.com.duiba.live.normal.service.api.dto.oto.interview.InterviewDetailDTO;
import cn.com.duiba.live.normal.service.api.dto.oto.interview.OtoCustomerViewDTO;
import cn.com.duiba.live.normal.service.api.param.oto.interview.InterviewFeedbackParam;
import cn.com.duiba.live.normal.service.api.param.oto.interview.OtoCustomerInterviewStatusParam;

import java.util.Date;
import java.util.List;

/**
 * 描述：手机工作台1.0，客户面访
 *
 * @author zhouziwu
 * @date 2022-03-23
 */
@AdvancedFeignClient
public interface RemoteCustInterviewService {
    /**
     * 客户参观社区，查询预约面访详情
     * @param custId 客户id
     * @param sellerId 销售id
     * @param interviewType 面访类型，1:普通面访 2:社区面访
     * @param interviewStatus 面访状态：{@link cn.com.duiba.live.normal.service.api.enums.oto.OtoCustInterviewStatusEnum}
     * @return AppointmentDetailDTO
     */
    AppointmentDetailDTO findAppointmentDetail(Long custId, Long sellerId, Integer interviewType, List<Integer> interviewStatus);

    /**
     * 批量创建客户面访记录
     * 1、一批客户中都没有正在进行中的面访，则创建成功并返回面访码ID集合；
     * 2、有一个以上有进行中面访，则创建失败，并返回不能创建的客户ID。
     * @param sellerId 销售ID
     * @param interviewType 面访类型，1:普通面访 2:社区面访
     * @param interviewStatus 面访状态：{@link cn.com.duiba.live.normal.service.api.enums.oto.OtoCustInterviewStatusEnum}
     * @param custIds 客户ID集合
     * @return info
     */
    BatchSaveInterviewResultDTO batchSaveInterviewInfo(Long sellerId, Integer interviewType, List<Integer> interviewStatus,
                                                       Date appointmentTime, List<Long> custIds);

    /**
     * 参观社区-预约面访编辑
     * @param id 客户面访码ID
     * @param appointmentTime 预约客户参观的时间
     * @return boolean
     */
    Boolean updateAppointment(Long id, Date appointmentTime);

    /**
     * 查看上传面访的信息
     * @param customerId 客户Id
     * @param sellerId 销售Id
     * @return detail info
     */
    InterviewDetailDTO findInterviewDetail(Long customerId, Long sellerId);

    /**
     * 查询面访打卡地点
     * @param id 客户面访码ID
     * @return address
     */
    String findInterviewAddress(Long id);

    /**
     * 面访客户后上传信息
     * @param param info
     * @return int
     */
    Integer saveInterviewFeedback(InterviewFeedbackParam param);

    /**
     * 取消面访
     * @param interviewId 面访ID
     * @return 操作结果
     */
    Boolean cancelInterview(Long interviewId) throws BizException;

    /**
     * 查询销售小程序二维码
     */
    OtoCustomerViewDTO getInterviewCode(Long id) throws BizException;

    /**
     * 查询销售小程序二维码
     */
    OtoCustomerViewDTO getInterviewStatus(OtoCustomerInterviewStatusParam param) throws BizException;
}
