package cn.com.duiba.live.normal.service.api.remoteservice.oto.interview;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.interview.*;
import cn.com.duiba.live.normal.service.api.param.oto.interview.InterviewAuthorizeEvaluateParam;
import cn.com.duiba.live.normal.service.api.param.oto.interview.InterviewFeedbackParam;
import cn.com.duiba.live.normal.service.api.param.oto.interview.OtoCustomerInterviewStatusParam;

import cn.com.duiba.live.normal.service.api.dto.oto.interview.OtoCustomerInterviewDto;
import cn.com.duiba.live.normal.service.api.param.oto.interview.OtoQueryInterviewRecordParam;
import java.util.Date;
import java.util.List;

/**
 * 描述：手机工作台1.0，客户面访
 *
 * @author zhouziwu
 * @date 2022-03-23
 */
@AdvancedFeignClient
public interface RemoteCustInterviewService {
    /**
     * 客户参观社区，查询预约面访详情
     * @param custId 客户id
     * @param sellerId 销售id
     * @param interviewType 面访类型，1:普通面访 2:社区面访
     * @param interviewStatus 面访状态：{@link cn.com.duiba.live.normal.service.api.enums.oto.OtoCustInterviewStatusEnum}
     * @return AppointmentDetailDTO
     */
    AppointmentDetailDTO findAppointmentDetail(Long custId, Long sellerId, Integer interviewType, List<Integer> interviewStatus);

    /**
     * 批量创建客户面访记录
     * 1、一批客户中都没有正在进行中的面访，则创建成功并返回面访码ID集合；
     * 2、有一个以上有进行中面访，则创建失败，并返回不能创建的客户ID。
     * @param sellerId 销售ID
     * @param interviewType 面访类型，1:普通面访 2:社区面访
     * @param interviewStatus 面访状态：{@link cn.com.duiba.live.normal.service.api.enums.oto.OtoCustInterviewStatusEnum}
     * @param appointmentTime 面访时间
     * @param custIds 客户ID集合
     * @return info
     */
    BatchSaveInterviewResultDTO batchSaveInterviewInfo(Long sellerId, Integer interviewType, List<Integer> interviewStatus,
                                                       Date appointmentTime, List<Long> custIds) throws BizException;

    /**
     * 参观社区-预约面访编辑
     * @param id 客户面访码ID
     * @param appointmentTime 预约客户参观的时间
     * @return boolean
     */
    Boolean updateAppointment(Long id, Date appointmentTime);

    /**
     * 查看上传面访的信息
     * @param id Id
     * @return detail info
     */
    InterviewDetailDTO findInterviewDetail(Long id);

    /**
     * 面访客户后上传信息
     * @param param info
     * @return int
     */
    Integer saveInterviewFeedback(InterviewFeedbackParam param);

    /**
     * 取消面访
     * @param interviewId 面访ID
     * @return 操作结果
     * @throws BizException 业务异常
     */
    Boolean cancelInterview(Long interviewId) throws BizException;

    /**
     * 查询销售小程序二维码
     */
    List<OtoCustomerViewDTO> getInterviewCode(List<Long> ids) throws BizException;

    /**
     * 查询客户授权状态
     */
    OtoCustomerViewDTO getInterviewStatus(OtoCustomerInterviewStatusParam param) throws BizException;

    /**
     * 手机端销售面访列表
     *
     * @param param 参数
     * @return 面访列表
     * @throws BizException 业务异常
     */

    List<OtoCustomerInterviewDto> sellerInterviewList(OtoQueryInterviewRecordParam param)
        throws BizException;


    /**
     * 获取客户系统中手机号和授权手机号
     */
    OtoCustomerPhoneDTO getInterviewPhone(Long id) throws BizException;
    /**
     * 绑定客户关系
     */
    Boolean interviewBind(Long id) throws BizException;

    /**
     * 客户面访评价
     * @param param 评价参数
     * @return 操作结果
     * @throws  BizException 业务参数异常
     */
    Boolean editEvaluate(InterviewAuthorizeEvaluateParam param) throws BizException;
}
