package cn.com.duiba.live.normal.service.api.remoteservice.pointreward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.pointreward.RewardVideoDto;
import cn.com.duiba.live.normal.service.api.dto.pointreward.RewardVideoInfoDto;
import cn.com.duiba.live.normal.service.api.dto.pointreward.RewardVideoListDto;
import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import cn.com.duiba.live.normal.service.api.param.pointreward.RewardVideoAddParam;
import cn.com.duiba.live.normal.service.api.param.pointreward.RewardVideoEditParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2021-03-08 15:12
 * @descript 点对点视频 remoteService
 */
@AdvancedFeignClient
public interface RemoteRewardVideoApiService {

    /**
     * 根据主键查询
     * @param id 视频id
     * @return 视频信息
     */
    RewardVideoDto findById(Long id);

    /**
     * 点对点抽奖-新增备选视频
     *
     * @param rewardVideoAddParam 备选视频
     * @return 视频id
     */
    Long addVideo(RewardVideoAddParam rewardVideoAddParam);

    /**
     * 点对点抽奖-删除备选视频
     *
     * @param videoId 备选视频
     * @return 视频id
     */
    boolean deleteVideo(Long videoId);

    /**
     * 点对点抽奖-编辑备选视频
     *
     * @param rewardVideoEditParam 视频参数
     * @return true成功 false失败
     */
    boolean editVideo(RewardVideoEditParam rewardVideoEditParam);

    /**
     * 获取备选视频详情
     *
     * @param videoId 视频id
     * @return 视频详情
     */
    RewardVideoInfoDto getVideoInfo(Long videoId);

    /**
     * 分页获取视频列表
     * @param offset 偏移量
     * @param rows 行数
     * @return 视频列表
     */
    List<RewardVideoListDto> listVideo(int offset, int rows);

    /**
     * 统计备选视频总数（仅管理端可用）
     *
     * @return 选视频总数
     */
    long countListVideo4Mng();

    /**
     * 分页获取备选视频详情
     * @param pageQuery 视频查询参数
     * @return 分页结果
     */
    List<RewardVideoInfoDto> listVideoInfo(PageQuery pageQuery);
}
