package cn.com.duiba.live.normal.service.api.remoteservice.liveclue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.liveclue.LiveClueTemplateDto;
import cn.com.duiba.live.normal.service.api.param.liveclue.LiveClueTemplateSearchParam;

import java.util.List;

/**
 * 直播 线索模板接口
 * @author 吴文哲
 * @date 2020-04-13 14:16
 **/
@AdvancedFeignClient
public interface RemoteLiveClueTemplateApiService {

    /**
     * 根据条件查询列表
     * @return
     */
    List<LiveClueTemplateDto> findByCondition(LiveClueTemplateSearchParam param);


    /**
     * 根据条件统计
     * @param param
     * @return
     */
    Integer countByCondition(LiveClueTemplateSearchParam param);

    /**
     * 新增模板
     * @param buildTemplateDto
     * @return
     */
    Long addTemplate(LiveClueTemplateDto buildTemplateDto);

    /**
     * 根据主键查找
     * @param templateId
     * @return
     */
    LiveClueTemplateDto findById(Long templateId);

    /**
     * 更新线索模板
     * @param updateDto
     * @return
     */
    Integer updateTemplate(LiveClueTemplateDto updateDto);

    /**
     * 物理删除
     * @param templateId
     * @return
     */
    Integer deleteTemplate(Long templateId);

    /**
     * 查找系统默认模板
     * @return 系统默认模版
     */
    LiveClueTemplateDto findSystemTemplate();

    /**
     * 根据直播id查询
     * @param liveId
     * @return
     */
    LiveClueTemplateDto findByLiveId(Long liveId);
}
