package cn.com.duiba.live.normal.service.api.dto.oto.cust;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.CustFlowEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustCoreMakerEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustForWhoEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustVisitProgressEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustWxStatusEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.cust.visit.OtoCustCommitStatusEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.cust.visit.OtoCustFamilyTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * OTO客户信息扩展表
 * @author kjj mybatis generator 
 * @date 2022-01-11
 */
@Data
public class OtoCustomerExtDto implements Serializable {
     
    private static final long serialVersionUID = 16418803615184972L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 客户id tb_oto_customer.id
     */
    private Long custId;

    /**
     * 流程组名称
     * @see CustFlowEnum
     */
    private Integer custFlow;

    /**
     * 加微状态  0:未主动发起加微 1:已主动添加-对方没反应 2:已主动添加-对方拒绝 3:已主动添加-对方已同意
     * @see OtoCustWxStatusEnum
     */
    private Integer addWxStatus;

    /**
     * 是否成交 0:否 1:是
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer dealFlag;

    /**
     * 保单号
     */
    private String dealNumber;

    /**
     *  是否提交养老计划方案
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer commitPlanFlag;

    /**
     * 客户是否已确认投保要素  0:否 1：是
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer commitInsure;

    /**
     * 客户未确认投保要素的原因
     */
    private String insureReason;

    /**
     * 产品id
     */
    private Long productId;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 提交方案后客户状态 1近期有机会成交 2近期无法成交 3拒绝
     * @see OtoCustCommitStatusEnum
     */
    private Integer commitCustStatus;

    /**
     * 核心决策人 0:不明或其他 1:本人或配偶 2:子女 3：父母
     * @see OtoCustCoreMakerEnum
     */
    private Integer coreMaker;

    /**
     * 参观进度 0：无参观意向 1：未参观-有参观意向 2：已预约参观时间 3：完成参观
     * @see OtoCustVisitProgressEnum
     */
    private Integer visitProgress;

    /**
     * 为谁考虑(多选) 0:自己 1：父母 2:其他 3家人
     * @see OtoCustForWhoEnum
     */
    private String forWho;

    /**
     * 入住人出生年份
     */
    private Integer roomerBirthYear;

    /**
     * 入住人城市
     */
    private String roomerCity;

    /**
     * 考虑原因 0刚需 1未来 2了解一下
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustReasonEnum
     */
    private Integer considerReason;

    /**
     * 付费压力 0有压力 1略有压力 2无压力
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustPressureEnum
     */
    private Integer payPressure;

    /**
     * 退休金 0:0-5000 1:5000-8000 2: 8000-12000 3：12000+
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustRetireMoneyEnum
     */
    private Integer retireMoney;

    /**
     * 参观机构（多选） 0：国寿 1:泰康 2太平 3:其他
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustVisitOrgEnum
     */
    private String visitOrg;

    /**
     * 资金情况 0:不详 1:无资金 2:资金已到位 3:资金近期到位 4:资金明年到位
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustMoneyEnum
     */
    private Integer hasMoney;

    /**
     * 房产情况
     */
    private Integer hasHouse;

    /**
     * 家人态度 0未商量过 1支持 2反对
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustFamilyAttitudeEnum
     */
    private Integer familyAttitude;

    /**
     * 理念是否认同 0不认同 1认同
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer ideaAgree;

    /**
     * 投保人 1自己 2配偶 3父母 4子女
     * @see OtoCustFamilyTypeEnum
     */
    private Integer insApplicant;

    /**
     * 被投保人 1自己 2配偶 3父母 4子女
     * @see OtoCustFamilyTypeEnum
     */
    private Integer insByApplicant;

    /**
     * 投保金额
     */
    private Integer insMoney;

    /**
     * 投保期数
     */
    private Integer insPeriod;
}