package cn.com.duiba.live.normal.service.api.dto.oto.interview;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.visit.OtoCustCommitStatusEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.cust.visit.OtoCustFamilyTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 描述：
 *
 * @author zhouziwu
 * @date 2022-03-25
 */
@Data
public class InterviewDetailDTO implements Serializable {
    /** 打卡地址 */
    private String interviewAddress;

    /** 面访备注 */
    private String interviewRemark;

    /** 客户姓名 */
    private String custName;

    /** 核心决策人 */
    private Integer coreMaker;

    /** 客户关注度 */
    private Integer followWeight;

    /**
     *  是否提交养老计划方案
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer commitPlanFlag;

    /**
     * 提交方案后客户状态 1近期有机会成交 2近期无法成交 3拒绝
     * @see OtoCustCommitStatusEnum
     */
    private Integer commitCustStatus;

    /**
     * 客户是否已确认投保要素  0:否 1：是
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer commitInsure;

    /**
     * 客户未确认投保要素的原因
     */
    private String insureReason;

    /**
     * 产品id
     */
    private Long productId;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 投保人 1自己 2配偶 3父母 4子女
     * @see OtoCustFamilyTypeEnum
     */
    private Integer insApplicant;

    /**
     * 被投保人 1自己 2配偶 3父母 4子女
     * @see OtoCustFamilyTypeEnum
     */
    private Integer insByApplicant;

    /**
     * 投保金额
     */
    private Integer insMoney;

    /**
     * 投保期数
     */
    private Integer insPeriod;

    /**
     * 面访异常类型
     */
    private List<Integer> unusualTypes;

    /**
     * 面访说明
     */
    private String unusualExplain;

    /**
     * 上传凭证
     */
    private List<String> unusualProofs;
}
