package cn.com.duiba.live.normal.service.api.enums.oto.audit;

/**
 * 描述：tb_audit_record 表的 audit_state 字段枚举，用于区分审核各阶段
 *
 * @author zhouziwu
 * @date 2022-04-21
 */
public enum AuditStateEnum {

    /** 待审批 */
    AUDIT_WAIT(1, "待审批"),

    /** 已通过 */
    AUDIT_PASS(2, "已通过"),

    /** 已驳回 */
    AUDIT_REJECT(3, "已驳回"),
    ;

    /** 审批状态枚举 */
    private final Integer state;

    /** 审批状态描述 */
    private final String desc;

    AuditStateEnum(Integer state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    public Integer getState() {
        return state;
    }

    public String getDesc() {
        return desc;
    }
}
