package cn.com.duiba.live.normal.service.api.enums.oto.audit;

/**
 * 描述：tb_audit_record 表的 audit_type 字段枚举，用于区分不同审核模块
 *
 * @author zhouziwu
 * @date 2022-04-21
 */
public enum AuditTypeEnum {

    /** 面访异常审批 */
    AUDIT_CUST_INTERVIEW(1, "面访异常审批"),

    ;

    /** 审批类型 */
    private Integer type;

    /** 审批描述 */
    private String desc;

    AuditTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
