package cn.com.duiba.live.normal.service.api.remoteservice.oto.interview;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.interview.*;
import cn.com.duiba.live.normal.service.api.param.oto.interview.CustomerBindWxUserParam;
import cn.com.duiba.live.normal.service.api.param.oto.interview.InterviewAuthorizeEvaluateParam;
import cn.com.duiba.live.normal.service.api.param.oto.interview.InterviewFeedbackParam;
import cn.com.duiba.live.normal.service.api.param.oto.interview.OtoCustomerInterviewStatusParam;
import cn.com.duiba.live.normal.service.api.param.oto.interview.OtoQueryInterviewRecordParam;

import java.util.Date;
import java.util.List;

/**
 * 描述：手机工作台1.0，客户面访
 *
 * @author zhouziwu
 * @date 2022-03-23
 */
@AdvancedFeignClient
public interface RemoteCustInterviewService {
    /**
     * 客户参观社区，查询预约面访详情
     * @param custId 客户id
     * @param sellerId 销售id
     * @param interviewType 面访类型，1:普通面访 2:社区面访
     * @param interviewStatus 面访状态：{@link cn.com.duiba.live.normal.service.api.enums.oto.OtoCustInterviewStatusEnum}
     * @return AppointmentDetailDTO
     */
    AppointmentDetailDTO findAppointmentDetail(Long custId, Long sellerId, Integer interviewType, List<Integer> interviewStatus);

    /**
     * 批量创建面访时，预检查
     * @param sellerId 销售id
     * @param interviewType 面访类型，1:普通面访 2:社区面访
     * @param interviewStatus 面访状态：{@link cn.com.duiba.live.normal.service.api.enums.oto.OtoCustInterviewStatusEnum}
     * @param custIds 客户ids
     * @return
     * @throws BizException
     */
    Boolean preCheckCustCanInterview(Long sellerId, Integer interviewType, List<Integer> interviewStatus, List<Long> custIds) throws BizException;

    /**
     * 批量创建客户面访记录
     * @param sellerId 销售ID
     * @param interviewType 面访类型，1:普通面访 2:社区面访
     * @param interviewStatus 面访状态：{@link cn.com.duiba.live.normal.service.api.enums.oto.OtoCustInterviewStatusEnum}
     * @param appointmentTime 面访时间
     * @param custIds 客户ID集合
     * @return info
     */
    List<Long> batchSaveInterviewInfo(Long sellerId, Integer interviewType, List<Integer> interviewStatus,
                                      Date appointmentTime, List<Long> custIds) throws BizException;

    /**
     * 更新面访码id
     * @param id 面访表主键
     * @param scanCodeId 面访码id
     * @return int
     */
    Boolean updateScanCodeIdById(Long id, Long scanCodeId);

    /**
     * 参观社区-预约面访编辑
     * @param id 主键id
     * @param appointmentTime 预约客户参观的时间
     * @return boolean
     */
    Boolean updateAppointment(Long id, Date appointmentTime);

    /**
     * 查看上传面访的信息
     * @param id Id
     * @return detail info
     */
    InterviewDetailDTO findInterviewDetail(Long id);

    /**
     * 进入面访信息上传页面时回显信息的接口
     * @param id id
     * @return detail info
     */
    InterviewDetailDTO custExtDetail(Long id);

    /**
     * 面访客户后上传信息
     * @param param info
     * @return int
     */
    Integer saveInterviewFeedback(InterviewFeedbackParam param) throws BizException;

    /**
     * 取消面访
     * @param interviewId 面访ID
     * @return 操作结果
     */
    Boolean cancelInterview(Long interviewId);

    /**
     * 查询销售小程序二维码
     */
    List<OtoCustomerViewDTO> getInterviewCode(List<Long> ids) throws BizException;

    /**
     * 查询客户授权状态
     */
    OtoCustomerViewDTO getInterviewStatus(OtoCustomerInterviewStatusParam param) throws BizException;

    /**
     * 手机端销售面访列表
     *
     * @param param 参数
     * @return 面访列表
     * @throws BizException 业务异常
     */
    OtoInterviewListDto sellerInterviewList(OtoQueryInterviewRecordParam param);


    /**
     * 获取客户系统中手机号和授权手机号
     */
    OtoCustomerPhoneDTO getInterviewPhone(Long id) throws BizException;
    /**
     * 绑定客户关系
     */
    Boolean interviewBind(Long id) throws BizException;

    /**
     * 绑定客户关系
     */
    Boolean interviewCancel(Long id) throws BizException;

    /**
     * 客户面访评价
     * @param param 评价参数
     * @return 操作结果
     */
    Boolean editEvaluate(InterviewAuthorizeEvaluateParam param) throws BizException;

    /**
     * 查询信息
     * @param id
     * @return
     */
    InterviewEditDetailDTO findInterviewEditDetail(Long id);

    /**
     * 客户绑定微信用户
     * @param param 参数
     * @return 操作结果
     * @throws BizException 用户不一致
     */
    Boolean customerBindWxUser(CustomerBindWxUserParam param) throws BizException;

    /**
     * 授权失败
     * @param param
     * @return
     * @throws BizException
     */
    Boolean authorizeFail(CustomerBindWxUserParam param) throws BizException;

    /**
     * 保存地理位置
     * @param otoInterviewStatusParam
     * @return
     * @throws BizException
     */
    Boolean saveAddress(OtoCustomerInterviewStatusParam otoInterviewStatusParam) throws BizException;

    /**
     * 查询授权状态
     * @param id
     * @return
     * @throws BizException
     */
    OtoCustomerViewDTO getInterviewStatusV1(Long id) throws BizException;

    /**
     * 查询面访异常类型
     * @param id
     * @return
     */
    List<Integer> getUnusualTypes(Long id) throws BizException;

    /**
     * 根据小程序码ID查询销售
     */
    OtoSellerDTO getSeller(Long scanCodeId) throws BizException;

    Boolean updateInterviewStatus() throws BizException;
}
