package cn.com.duiba.live.normal.service.api.util;

import cn.com.duiba.live.normal.service.api.dto.advice.LiveAdviceSessionDto;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * 直播聊天室-会话信息工具类
 * @author lizhi
 * @date 2020/7/2 1:43 PM
 */
public class LiveAdviceSessionUtil {

    private static final String SESSION_ENCRYPT = "89a1657cb6a3";

    private LiveAdviceSessionUtil() {}

    /**
     * 聊天室唯一标识，由live_id、live_agent_id、live_visitor_id下划线组成字符串的MD5
     * @param liveId 直播ID
     * @param liveAgentId 代理人ID
     * @param liveVisitorId 访客ID
     * @return 唯一标识
     */
    public static String getSessionKey(Long liveId, Long liveAgentId, Long liveVisitorId) {
        return DigestUtils.md5Hex(liveId + "_" + liveAgentId + "_" + liveVisitorId);
    }

    /**
     * 获取sessionId
     * @param liveId 直播ID
     * @param agentId 代理人ID
     * @param agentLiveUserId 代理人直播用户ID
     * @param visitorLiveUserId 访客直播用户ID
     * @return sessionId
     */
    public static String getSessionId(Long liveId, Long agentId, Long agentLiveUserId, Long visitorLiveUserId) {
        LiveAdviceSessionDto dto = new LiveAdviceSessionDto();
        dto.setLId(liveId);
        dto.setAId(agentId);
        dto.setAVId(agentLiveUserId);
        dto.setVId(visitorLiveUserId);
        return getSessionId(dto);
    }

    public static void main(String[] args) {
        System.out.println(getSessionId(8L,38L,19L,72L));;
    }

    /**
     * 获取sessionId
     * @param dto session对象
     * @return sessionId
     */
    public static String getSessionId(LiveAdviceSessionDto dto) {
        if (dto == null) {
            return "";
        }
        try {
            return BlowfishUtils.encryptBlowfish(JSON.toJSONString(dto), SESSION_ENCRYPT);
        } catch (Exception e) {
            return "";
        }
    }

    /**
     * 解析sessionId
     * @param sessionId sessionId
     * @return session对象
     */
    public static LiveAdviceSessionDto getLiveAdviceSessionDto(String sessionId) {
        if (StringUtils.isBlank(sessionId) || "undefined".equals(sessionId) || StringUtils.equals(sessionId,"null")) {
            return null;
        }
        try {
            String content = BlowfishUtils.decryptBlowfish(sessionId, SESSION_ENCRYPT);
            return JSON.parseObject(content, LiveAdviceSessionDto.class);
        } catch (Exception e) {
            return null;
        }
    }
}
