package cn.com.duiba.live.normal.service.api.param.advice;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 直播咨询记录表
 * @author kjj mybatis generator
 * @date 2020-06-30
 */
@ToString(callSuper = true)
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveAdviceRecordSearchParam extends PageQuery {

    private static final long serialVersionUID = 15935024671273068L;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 直播代理人id
     */
    private Long liveAgentId;

    /**
     * 已读标识 0：未读 1：已读
     * @see cn.com.duiba.live.normal.service.api.enums.advice.AdviceReadFlagEnum
     */
    private Integer readFlag;

    /**
     * 回复类型 0：访客回复 1：代理人回复 2:代理人自动回复
     * @see cn.com.duiba.live.normal.service.api.enums.advice.AdviceChatTypeEnum
     */
    private Integer chatType;

    /**
     * 聊天室唯一标识，由live_id、live_agent_id、live_visitor_id下划线组成字符串的MD5
     */
    private String sessionKey;
}
