package cn.com.duiba.live.normal.service.api.dto.oto.cust;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Data;

/**
 * @author xuanhongjian
 */
@Data
public class MyCustomerListForPhoneDto implements Serializable {

    private static final long serialVersionUID = 8475570796305812615L;

    /***
     * 客户ID
     */
    private Long id;

    /**
     * 客户姓名
     */
    private String custName;

    /**
     * 客户来源 
     */
    private Integer custSource;

    /**
     * 通话次数
     */
    private Integer callNum;

    /**
     * 线下拜访次数
     */
    private Integer interviewNum;

    /**
     * 标签
     */
    private List<String> custTags;

    /**
     * 跟进时间 需要按照次字段降序排序
     */
    private Date lastFollowTime;

    public MyCustomerListForPhoneDto(Long id) {
        this.id = id;
    }

    public MyCustomerListForPhoneDto() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MyCustomerListForPhoneDto phoneDto = (MyCustomerListForPhoneDto) o;
        return id.equals(phoneDto.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
