package cn.com.duiba.live.normal.service.api.param.oto.cust;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.CustSourceEnum;
import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * OTO-客户列表分页查询参数
 *
 * @author ZhangJun
 * @date 2022/1/5 7:38 下午
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoCustPageListParam extends PageQuery {

    private static final long serialVersionUID = -210708968627650589L;

    /**
     * 客户手机号
     */
    private String phoneNum;

    /**
     * 客户价值
     */
    private List<Integer> custValueList;

    /**
     * 分配状态,0-待分配，1-已分配
     * {@link cn.com.duiba.live.normal.service.api.enums.oto.cust.OtoCustAssignStatusEnum}
     */
    private Integer assignStatus;

    /**
     * 分配类型
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustAssignTypeEnum
     */
    private List<Integer> assignTypes;

    /**
     * 跟进状态
     */
    private List<Integer> followStatusList;

    /**
     * 当前跟进人id
     */
    private List<Long> otoSidList;

    /**
     * 搜索客户id
     */
    private List<Long> custIdList;

    /**
     * 起始分配时间
     */
    private Date assignBeginTime;

    /**
     * 结束分配时间
     */
    private Date assignEndTime;

    /**
     * 客户所属保险公司id,tb_oto_company.id
     */
    private Long custCompany;

    /**
     * 所处资源池类型
     *
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.OtoCustPoolEnum
     */
    private List<Integer> poolTypes;

    /**
     * 流程组状态
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.CustFlowEnum
     */
    private Integer custFlow;

    /**
     * 客户来源
     * @see CustSourceEnum
     */
    private Integer custSource;
}
