package cn.com.duiba.live.normal.service.api.param.oto.cust;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.CustSourceEnum;
import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * OTO-客户列表分页查询参数
 *
 * @author ZhangJun
 * @date 2022/1/5 7:38 下午
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoCustPageParam extends PageQuery {

    private static final long serialVersionUID = 4378618085361525345L;

    /**
     * 搜索客户名称
     */
    private String custName;
    /**
     * 客户手机号
     */
    private String phoneNum;

    /**
     * 分配状态,0-待分配，1-已分配
     * {@link cn.com.duiba.live.normal.service.api.enums.oto.cust.OtoCustAssignStatusEnum}
     */
    private Integer assignStatus;

    /**
     * 客户价值
     * {@link cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustValueEnum}
     */
    private List<Integer> custValueList;

    /**
     * id主键
     */
    private List<Long> idList;

    /**
     * 所属保险公司id
     */
    private Long companyId;

    /**
     * 所处资源池类型
     *
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.OtoCustPoolEnum
     */
    private List<Integer> poolTypes;

    /**
     * 客户来源
     * @see CustSourceEnum
     */
    private Integer custSource;

    /**
     * 销售id排序扰动因子
     */
    private Long modNum;

    /**
     * 需要过滤的客户
     */
    private List<Long> notInCustIds;
}
