package cn.com.duiba.live.normal.service.api.enums.pub.form.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 公域引流-用户管理见面情况枚举
 *
 * @author xiaocong
 * @date 2021/11/16 11:08 上午
 */
@Getter
@AllArgsConstructor
public enum PubFormCustomerMeetCustomerEnum {

    /**
     * 未见面
     */
    UN_MEET(0, "否"),

    /**
     * 已见面
     */
    MEET(1, "是");

    /**
     * code
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String description;


    public static final Map<Integer, String> MEET_MAP;

    static {
        Map<Integer, String> map = Arrays.stream(values()).collect(Collectors.toMap(PubFormCustomerMeetCustomerEnum::getCode, PubFormCustomerMeetCustomerEnum::getDescription));
        MEET_MAP = Collections.unmodifiableMap(map);
    }

}
