package cn.com.duiba.live.normal.service.api.enums.oto;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * OTO-任务配置-客户状态
 * @author Meichang
 */
@Getter
@AllArgsConstructor
public enum OtoCustConfStatusEnum {

    NOT_CONTACT(1, "未联系过"),
    NOT_CONNECT(2, "未打通过"),
    NOT_LONG_CONTACT(3, "长时间未联系"),
    ;
    private Integer code;

    private String desc;

    public static OtoCustConfStatusEnum getByCode(Integer code) {
        for (OtoCustConfStatusEnum otoCustConfStatusEnum : OtoCustConfStatusEnum.values()) {
            if (otoCustConfStatusEnum.getCode().equals(code)) {
                return otoCustConfStatusEnum;
            }
        }
        return null;
    }
}
