package cn.com.duiba.live.normal.service.api.enums.oto;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * OTO-任务配置-客户类型
 * @author Meichang
 */
@Getter
@AllArgsConstructor
public enum OtoCustTypeEnum {

    ALL_CUST(1, "全部客户"),
    NEW_CUST(2, "新客户"),
    OLD_CUST(3, "老客户")
    ;

    private Integer code;

    private String desc;

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustTypeEnum::getCode, OtoCustTypeEnum::getDesc, (v1, v2)->v1)));


    public static String getDescByCode(Integer code){
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }
}
