package cn.com.duiba.live.normal.service.api.enums.oto.event;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-02-09 13:50
 */
@Getter
@AllArgsConstructor
public enum OtoFollowEventTypeEnum {

    /**
     * 只修改客户分类
     */
    STAR_CUST(101, "给客户打星标/取消星标"),
    CALL_CUST(102, "只给客户打电话，还未填写反馈"),

    /**
     * 只修改客户跟进状态
     */
    EDIT_CUST(201, "编辑客户资料，修改客户状态"),

    /**
     * 修改客户分类，跟进状态，跟进时间，跟进次数
     */
    REFRESH_DATA(301, "手动刷数据，修改客户跟进信息"),
    MEET_CUST(302, "会见客户，修改客户跟进信息"),
    VISIT_FEEDBACK_CUST(303, "带领客户参观后填写反馈，修改客户跟进信息"),
    CALL_FEEDBACK_CUST(304, "给客户打电话成功后，填写反馈，修改客户跟进信息")
    ;

    private final Integer eventType;

    private final String desc;
}
