package cn.com.duiba.live.normal.service.api.param.oto.interview;


import cn.com.duiba.live.normal.service.api.enums.oto.interview.InterviewTypeEnum;
import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 移动端面访列表查询
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OtoQueryInterviewRecordParam implements Serializable {

    private static final long serialVersionUID = -8821094918086963878L;

    /**
     * 面访类型
     *
     * @see InterviewTypeEnum
     */
    private Integer interviewType;

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 是否完成 0进行中 1已完成 2审批中 3已失效
     */
    private Integer isFinish;


    /**
     * 最后一条记录ID
     */
    private Long lastId;

    /**
     * 分页大小
     */
    private Integer pageSize;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 面访状态
     */
    private List<Integer> interviewStatus;
}
