package cn.com.duiba.live.normal.service.api.dto.oto.notification;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 客户告知书签名记录表
 * @author kjj mybatis generator 
 * @date 2022-05-25
 */
@Data
public class NotificationRecordDTO implements Serializable {
     
    private static final long serialVersionUID = 1653481577506425L;

    /** 告知书id */
    private Long id;

    /** 客户姓名 */
    private String custName;

    /** 销售姓名 */
    private String sellerName;

    /** 供应商名称 */
    private String supplierName;

    /** 产品名称 */
    private String productName;

    /** 投保单号 */
    private String insureOrder;

    /** 签署日期 */
    private Date signatureDate;

    /** 签署状态 {@link cn.com.duiba.live.normal.service.api.enums.oto.OtoNotificationSignatureStateEnum} */
    private Integer signatureState;

    /** 产品id，tb_product.id */
    private Long productId;

    /** 客户告知书链接 */
    private String notificationUrl;
}