package cn.com.duiba.live.normal.service.api.enums.oto.seller;

import com.google.common.collect.ImmutableMap;
import lombok.Getter;


/**
 * @author liuyj
 * @date 2022/5/25 20:21
 */
@Getter
public enum SellerTypeEnum {

    DEPEND_ON("挂靠销售", "depend_on"),
    AUTARKY("自营销售", "autarky"),
    ORTHER_AUTARKY("自营其他销售", "orther_autarky"),
    ;
    private static final ImmutableMap<String, SellerTypeEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<String, SellerTypeEnum> builder = ImmutableMap.builder();
        for (SellerTypeEnum item : SellerTypeEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    private final String desc;
    private final String code;

    SellerTypeEnum(String desc, String code) {
        this.desc = desc;
        this.code = code;
    }
}
