package cn.com.duiba.live.normal.service.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.live.LiveUserAppointmentDto;
import cn.com.duiba.live.normal.service.api.param.live.LiveUserAppointmentSearchParam;

import java.util.List;
import java.util.Map;

/**
 * 用户预约服务
 * @author zhanghuifeng
 * date 2020/4/5-11:47 上午
 */
@AdvancedFeignClient
public interface RemoteLiveUserAppointmentApiService {

    /**
     * 保存
     * @param dto
     * @return
     */
    int save(LiveUserAppointmentDto dto);

    /**
     * 新增 主键id
     *
     * @param dto 用户预约实体
     * @return id
     */
    long insertGeneratedKeys(LiveUserAppointmentDto dto);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    int selectCount(LiveUserAppointmentSearchParam param);

    /**
     * 根据条件查询列表
     * @param param
     * @return
     */
    List<LiveUserAppointmentDto> findByCondition(LiveUserAppointmentSearchParam param);

    /**
     * 查询用户业务ID对应预约次数
     * @param liveUserId 用户ID
     * @param bizIdList 业务ID集合
     * @param bizType 业务类型
     * @see cn.com.duiba.live.normal.service.api.enums.live.UserAppointmentBizTypeEnum
     * @return key：业务ID，value：预约次数
     */
    Map<Long, Long> getUserBizAppointmentCount(Long liveUserId, List<Long> bizIdList, Integer bizType);

    /**
     * 查询用户关注次数
     */
    Map<Long, Integer> getUserAppointmentCount(List<Long> liveUserIds, Long bizId, Integer bizType);

    /**
     * 查询业务ID对应预约人数
     * @param bizIdList 业务ID集合
     * @param bizType 业务类型
     * @see cn.com.duiba.live.normal.service.api.enums.live.UserAppointmentBizTypeEnum
     * @return key:业务ID，value：预约人数
     */
    @Deprecated
    Map<Long, Long> getBizAppointmentCount(List<Long> bizIdList, Integer bizType);

    /**
     * 查询业务ID对应预约人数
     * @param bizIdList 业务ID集合
     * @param bizType 业务类型
     * @see cn.com.duiba.live.normal.service.api.enums.live.UserAppointmentBizTypeEnum
     * @param appointmentFlag 预约标识
     * @see cn.com.duiba.live.normal.service.api.enums.live.UserAppointmentBizTypeEnum
     * @return key:业务ID，value：预约人数
     */
    Map<Long, Long> getBizAppointmentNum(List<Long> bizIdList, Integer bizType, Integer appointmentFlag);

    /**
     * 批量标记预约用户为到场
     * @param ids 主键id列表
     * @return 影响行数
     */
    int batchMarkPresent(List<Long> ids);

    /**
     * 根据条件查询预约直播间记录id列表 不分页
     * @param param 查询参数
     * @return 主键id列表
     */
    List<Long> findIdByCondition(LiveUserAppointmentSearchParam param);

    /**
     * 根据主键id标记到场
     * @param ids 主键id列表
     * @return 影响行数
     */
    int batchMarkPresentByIds(List<Long> ids);
}
