package cn.com.duiba.live.normal.service.api.remoteservice.rewardSignRecord;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.rewardSignRecord.LiveVisitorRewardRedDto;
import cn.com.duiba.live.normal.service.api.param.common.PageQuery;

import java.util.List;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2021/1/27 11:32
 */
@AdvancedFeignClient
public interface RemoteLiveRewardRedService {

    /**
     * 根据直播id和用户id查询
     *
     * @param liveId        业务id
     * @param liveVisitorId 直播访客用户id
     * @return 直播访客奖品提交领取红包记录
     */
    @Deprecated
    LiveVisitorRewardRedDto selectByLiveAndVisitor(Long liveId, Long liveVisitorId);


    /**
     * 根据直播id和用户id查询
     *
     * @param liveId        业务id
     * @param liveVisitorId 直播访客用户id
     * @param rewardType    1:确认红包 2：签收红包
     * @return 直播访客奖品提交领取红包记录
     */
    LiveVisitorRewardRedDto selectByLiveAndVisitorAndRewardType(Long liveId, Long liveVisitorId, Integer rewardType);

    /**
     * 分页查询代理人下访客领红包明细
     * @param liveId 直播ID
     * @param agentId 代理人ID
     * @param rewardTypeList 领红包类型：1:确认红包 2:签收红包 3:代理人核奖红包
     * @see cn.com.duiba.live.normal.service.api.enums.rewardSignRecord.RedRewardTypeEnum
     * @param pageQuery 分页参数
     * @return 明细列表
     */
    List<LiveVisitorRewardRedDto> select4AgentRewardList(Long liveId, Long agentId, List<Integer> rewardTypeList, PageQuery pageQuery);

    /**
     * 新增
     *
     * @param dto 直播访客奖品提交领取红包记录
     * @return 主键id
     */
    LiveVisitorRewardRedDto insert(LiveVisitorRewardRedDto dto);
}
