package cn.com.duiba.live.normal.service.api.dto.oto.seller;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * oto销售扩展表
 * @author kjj mybatis generator 
 * @date 2022-05-30
 */
@Data
public class OtoSellerExtDto implements Serializable {
     
    private static final long serialVersionUID = 16538896769009287L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 销售 ID tb_oto_seller.id
     */
    private Long sellerId;

    /**
     * 销售人员编码
     */
    private String sellerCode;

    /**
     * 入职时间
     */
    private Date inductionTime;

    /**
     * 证件类型 id_card:身份证
     */
    private String certificateType;

    /**
     * 证件号
     */
    private String certificateNumber;

    /**
     * 性别 0女 1男
     */
    private Byte sellerGender;

    /**
     * 出生日期
     */
    private Date birthTime;

    /**
     * 工资卡开户行
     */
    private String bankAccount;

    /**
     * 工资卡卡号
     */
    private String bankAccountNumber;

    /**
     * 签约类型 劳务合同：labour_service 劳动合同:labour
     */
    private String signedType;

    /**
     * 签约合同编号
     */
    private String serialNumber;

    /**
     * 签约合同
     */
    private String contractSign;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 离职时间
     */
    private Date leaveTime;

    /**
     * 文化程度
     */
    private Byte leaveOfEducation;

    /**
     * 毕业证书
     */
    private String diploma;

    /**
     * 一寸照片
     */
    private String oneInchPhoto;

    /**
     * 政治面貌
     */
    private Byte politicCountenance;

    /**
     * 民族
     */
    private Byte nation;

    /**
     * 家庭住址
     */
    private String homeAddress;
}