package cn.com.duiba.live.normal.service.api.param.oto.cust;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.CustGenderEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-12 13:40
 */
@Data
public class OtoCustomerEditParam implements Serializable {

    private static final long serialVersionUID = -380981159017959838L;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 客户姓名
     */
    private String custName;

    /**
     * 省市区
     */
    private String custArea;

    /**
     * 备注
     */
    private String custDescription;

    /**
     * 加微信状态
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustWxStatusEnum
     */
    private Integer addWxStatus;

    /**
     * 参观进度
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustVisitProgressEnum
     */
    private Integer visitProgress;

    /**
     * 是否成交
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer dealFlag;

    /**
     * 保单号
     */
    private String dealNumber;

    /**
     * 提交后客户状态
     */
    private Integer commitCustStatus;

    /**
     *  是否提交养老计划方案
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer commitPlanFlag;

    /**
     * 客户是否已确认投保要素  0:否 1：是
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer commitInsure;

    /**
     * 客户未确认投保要素的原因
     */
    private String insureReason;

    /**
     * 产品id
     */
    private Long productId;

    /**
     * 核心决策人
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustCoreMakerEnum
     */
    private Integer coreMaker;

    /**
     * 客户出生年份
     */
    private String custBirthYear;

    /**
     * 为谁考虑
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustForWhoEnum
     */
    private List<Integer> forWho;

    /**
     * 入住人出生年份
     */
    private Integer roomerBirthYear;

    /**
     * 入住人所在城市
     */
    private String roomerCity;

    /**
     * 考虑原因
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustReasonEnum
     */
    private Integer considerReason;

    /**
     * 保费付费压力
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustPressureEnum
     */
    private Integer payPressure;

    /**
     * 退休金
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustRetireMoneyEnum
     */
    private Integer retireMoney;

    /**
     * 参观机构
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustVisitOrgEnum
     */
    private List<Integer> visitOrg;

    /**
     * 资金情况
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustMoneyEnum
     */
    private Integer hasMoney;

    /**
     * 房产情况
     */
    private Integer hasHouse;

    /**
     * 家人态度
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustFamilyAttitudeEnum
     */
    private Integer familyAttitude;

    /**
     * 理念是否认同
     */
    private Integer ideaAgree;

    /**
     * 投保人
     */
    private Integer insApplicant;

    /**
     * 被投保人
     */
    private Integer insByApplicant;

    /**
     * 投保金额
     */
    private Integer insMoney;

    /**
     * 投保期数
     */
    private Integer insPeriod;

    /**
     * 客户地址
     */
    private String custAddress;

    /**
     * 客户性别
     * @see CustGenderEnum
     */
    private Integer custGender;
}
