package cn.com.duiba.live.normal.service.api.remoteservice.birthday;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.birthday.LiveBirthdayRecordDto;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2021/3/21 17:19
 */
@AdvancedFeignClient
public interface RemoteLiveBirthdayRecordApiService {

    /**
     * 根据唯一索引查询一条记录
     * @param liveId 直播id
     * @param liveVisitorId 直播访客id
     * @return 直播生日会记录
     */
    LiveBirthdayRecordDto selectOne(Long liveId, Long liveVisitorId);

    /**
     * 新增
     * @param dto 直播生日会记录
     * @return 执行结果
     */
    int insert(LiveBirthdayRecordDto dto);
}
