package cn.com.duiba.live.normal.service.api.param.oto.cust;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.CustFlowEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.cust.CustSourceEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 移动端客户列表
 *
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OtoPhoneCustomerListParam implements Serializable {

    private static final long serialVersionUID = 2824979824607197988L;


    /**
     * 客户来源
     * @see CustSourceEnum
     */
    private List<Integer> custSource;

    /**
     * 客户阶段流程
     * @see CustFlowEnum
     */
    private List<Integer> custFlow;

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 最后一条记录客户ID
     */
    private Long lastCustId;

    /**
     * 每次查询数目
     */
    private Integer pageSize;

    /**
     * 销售ID
     */
    private Long sellerId;
}
