package cn.com.duiba.live.normal.service.api.remoteservice.oto.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.company.OtoCompanyDto;
import cn.com.duiba.live.normal.service.api.param.oto.company.OtoCompanySearchParam;

import java.util.List;

/**
 * Created by hong
 * time 2022/2/15.
 */
@AdvancedFeignClient
public interface RemoteOtoCompanyService {
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return OTO公司信息集合
     */
    List<OtoCompanyDto> selectList(OtoCompanySearchParam param);



    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return OTO公司信息集合
     */
    List<OtoCompanyDto> pageList(OtoCompanySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(OtoCompanySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return OTO公司信息
     */
    OtoCompanyDto selectById(Long id);

    /**
     * 新增
     * @param dto OTO公司信息
     * @return 执行结果
     */
    int insert(OtoCompanyDto dto);

    /**
     * 更新
     * @param dto OTO公司信息
     * @return 执行结果
     */
    int update(OtoCompanyDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 查询所有公司
     * 管理后台专用
     */
    List<OtoCompanyDto> listAll();

    /**
     * 根据ids查询公司
     * @param companyIds
     * @return
     */
    List<OtoCompanyDto> listCompanyByIds(List<Long> companyIds);
}
