package cn.com.duiba.live.normal.service.api.dto.follow;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 代理人跟进机会表
 * @author kjj mybatis generator 
 * @date 2021-07-23
 */
@Data
public class AgentFollowChanceDto implements Serializable {
     
    private static final long serialVersionUID = 16270201099692477L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 代理人id
     */
    private Long agentId;

    /**
     * 客户id
     */
    private Long liveVisitorId;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 业务id
     */
    private Long bizConfId;

    /**
     * 跟进机会类型
     * @see cn.com.duiba.live.normal.service.api.enums.follow.FollowChanceTypeEnum
     */
    private Integer chanceType;

    /**
     * 跟进机会获得时间
     */
    private Date gainChanceTime;

    /**
     * 是否同意标记
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer agreeFlag;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}