package cn.com.duiba.live.normal.service.api.dto.oto.cust.init;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.OtoCustLevelEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-06-17 15:14
 */
@Data
public class OtoCustomerInitDto implements Serializable {

    private static final long serialVersionUID = -6967320930613088270L;

    /**
     * 手机号码
     */
    private String phoneNum;

    /**
     * 客户来源
     */
    private Integer custSource;

    /**
     * 客户资源ext
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.CustSourceExtEnum
     */
    private Integer custSourceExt;

    /**
     * 客户姓名
     */
    private String custName;

    /**
     * 客户等级（为空则默认B）
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.OtoCustLevelEnum
     */
    private Integer custLevel = OtoCustLevelEnum.B.getCustLevel();

    /**
     * 客户所在区域（为空则默认为手机号归属地）
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.OtoCustLevelEnum
     */
    private String custArea;
}
