package cn.com.duiba.live.normal.service.api.enums.lottery;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/6/4 10:29 AM
 *
 */
public enum LiveLotteryCodeSourceEnum {

    APPOINTMENT(1,"预约",true),
    SIGN_IN(2,"签到",true),
    SUBSCRIBE(3,"关注直播间",true),
    ACCUMULATE_READ(4,"累计观看",false),
    FRIEND_INVITE(5,"邀请好友",false),
    VEST(6,"马甲",false),
    AUTH_PHONE(7,"授权手机号",true),
    LUCK_TASK(8, "幸运任务",false),
    SAVE_SHARE_POSTER(9, "保存分享海报",true),
    SUBMIT_SURVEY(10, "提交问卷",true),
    TREASURE(11,"惊喜宝箱",false),
    GUESS_RED(12,"猜数红包",false),
    FLIP_CARD(13,"翻牌拿红包",false),
    TIME_RED(14,"看直播攒现金",false),
    FORTUNE_RED(15,"好运红包",false),
    FLIP_WORD(16,"翻牌集字",false),
    WATCH_VIDEO(17,"观看视频",true),
    PLACE_ORDER(18, "成功下单", false),
    GOLDEN_EGG_TREASURE(19, "砸金蛋", false),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 是否限制唯一
     * 有唯一性约束
     */
    private final Boolean unit;

    private static final Map<Integer,LiveLotteryCodeSourceEnum> valueMap = new HashMap<>();

    static {
        for (LiveLotteryCodeSourceEnum enumVal : LiveLotteryCodeSourceEnum.values()) {
            valueMap.put(enumVal.getType(),enumVal);
        }
    }

    LiveLotteryCodeSourceEnum(Integer type ,String desc,Boolean unit){
        if (type == 0 || type == -1){
            //0 在redis数据结构中作为抽奖码总数key
            // -1 作为已使用的抽奖码列表
            throw new UnsupportedOperationException();
        }
        this.type  = type;
        this.desc  = desc;
        this.unit = unit;
    }

    public static LiveLotteryCodeSourceEnum getByType(Integer type) {
        return valueMap.get(type);
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public Boolean getUnit() {
        return unit;
    }
}
