package cn.com.duiba.live.normal.service.api.enums.oto.cust.ext;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-11 13:59
 */
@Getter
@AllArgsConstructor
public enum OtoCustForWhoEnum {

    SELF(0, "自己"),
    PARENTS(1, "父母"),
    OTHER(2, "其他"),
    FAMILY(3, "家人");


    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustForWhoEnum::getType, OtoCustForWhoEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据类型获取描述
     */
    public static String getDescByTypes(String types){
        if (StringUtils.isBlank(types)) {
            return null;
        }
        return Arrays.stream(types.split(",")).map(Integer::parseInt).map(ALL_MAP::get).collect(Collectors.joining(","));
    }
}
