package cn.com.duiba.live.normal.service.api.param.oto.audit;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 业务通用审批表
 * @author kjj mybatis generator 
 * @date 2022-04-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class AuditRecordSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16505078604903398L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务id，审核涉及哪个表就是哪个表的主键
     */
    private Long businessId;

    /**
     * tb_oto_seller.id
     */
    private Long sellerId;

    /**
     * 审批状态:1.待审批 2.已通过 3.已驳回
     * @see cn.com.duiba.live.normal.service.api.enums.oto.audit.AuditStateEnum
     */
    private Integer auditState;

    /**
     * 审批类型:1.面访异常审批(tb_cust_interview_record) 后续增加了审核模块可以加入
     * @see cn.com.duiba.live.normal.service.api.enums.oto.audit.AuditTypeEnum
     */
    private Integer auditType;

    /**
     * 审批备注
     */
    private String auditRemark;

    /**
     * 审批时间
     */
    private Date auditTime;

    /**
     * 创建时间(提交时间)
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}